<?php
require_once "../includes/db.php";
require_once "../includes/functions.php";
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="UTF-8">
  <title>لوحة التحكم - الكندي</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@400;600;800&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">
  <style>
    body {
      margin: 0;
      font-family: 'Cairo', sans-serif;
      background: #0a0a0a;
      color: #eee;
    }
    .admin-header {
      background: #1a1a1a;
      color: #fff;
      padding: 15px 30px;
      display: flex;
      justify-content: space-between;
      align-items: center;
      border-bottom: 2px solid var(--primary-color, #D4AF37);
    }
    .admin-header .logo {
      font-size: 20px;
      font-weight: bold;
      color: #D4AF37;
      text-decoration: none;
    }
    .admin-nav {
      display: flex;
      gap: 20px;
    }
    .admin-nav a {
      color: #ccc;
      text-decoration: none;
      font-weight: 600;
      transition: 0.3s;
    }
    .admin-nav a:hover {
      color: #D4AF37;
    }
    .admin-container {
      width: 95%;
      margin: 30px auto;
    }
    .card {
      background: #121212;
      padding: 20px;
      border-radius: 8px;
      margin-bottom: 20px;
      box-shadow: 0 3px 10px rgba(0,0,0,0.4);
    }
    .btn {
      background: #D4AF37;
      border: none;
      padding: 6px 14px;
      border-radius: 4px;
      font-weight: bold;
      cursor: pointer;
      transition: 0.3s;
      color: #000;
      text-decoration: none;
      display: inline-block;
    }
    .btn:hover {
      background: #ffd700;
      transform: translateY(-2px);
    }
    table {
      width: 100%;
      border-collapse: collapse;
      background: #121212;
    }
    table th, table td {
      padding: 10px;
      border-bottom: 1px solid #2a2a2a;
      text-align: center;
    }
    table th {
      background: #1a1a1a;
      color: #D4AF37;
    }
    .status {
      padding: 4px 10px;
      border-radius: 4px;
      font-size: 13px;
    }
    .status.بانتظار { background: #444; color: #fff; }
    .status.مؤكد { background: #2e7d32; color: #fff; }
    .status.مرفوض { background: #c62828; color: #fff; }
  </style>
</head>
<body>
  <header class="admin-header">
    <a href="index.php" class="logo"><i class="fas fa-gem"></i> لوحة التحكم</a>
    <nav class="admin-nav">
      <a href="index.php"><i class="fas fa-home"></i> الرئيسية</a>
      <a href="products.php"><i class="fas fa-box"></i> المنتجات</a>
	        <a href="orders.php"><i class="fas fa-receipt"></i> الطلبات</a>
			<a href="about.php"><i class="fas fa-receipt"></i> من نحن</a>
	        <a href="features.php"><i class="fas fa-receipt"></i> ما يميزنا</a>
	        <a href="sliders.php"><i class="fas fa-receipt"></i> السلايدر العلوي</a>
<a href="home_banners.php"><i class="fas fa-receipt"></i> السلايدر السفلي</a>
	        <a href="messages.php"><i class="fas fa-receipt"></i> البريد الوارد</a>
	        <a href="partners.php"><i class="fas fa-receipt"></i> الشركاء</a>
      <a href="blog.php"><i class="fas fa-newspaper"></i> المقالات</a>
      <a href="seo.php"><i class="fas fa-search"></i> SEO</a>
      <a href="settings.php"><i class="fas fa-cogs"></i> الإعدادات</a>
    </nav>
  </header>
  <div class="admin-container">
