<?php
// admin/order_view.php — عرض طلب
require_once "../config/db.php";
require_once "../includes/auth.php";
include "partials/header.php";

// دالة هروب آمن لمنع Deprecated: htmlspecialchars(null)
if (!function_exists('e')) {
  function e($v): string {
    return htmlspecialchars((string)($v ?? ''), ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8');
  }
}

$order_id = (int)($_GET['id'] ?? 0);
if ($order_id <= 0) {
  echo "<p style='color:red; text-align:center;'>طلب غير موجود</p>";
  include "partials/footer.php";
  exit;
}

// جلب بيانات الطلب + المستخدم + الحساب البنكي
$sql = "SELECT o.*,
               u.name AS user_name, u.email, u.phone,
               b.bank_name, b.account_holder, b.iban
        FROM orders o
        JOIN users u ON o.user_id = u.id
        JOIN bank_accounts b ON o.bank_account_id = b.id
        WHERE o.id=? LIMIT 1";
$stmt = db()->prepare($sql);
$stmt->execute([$order_id]);
$order = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$order) {
  echo "<p style='color:red; text-align:center;'>❌ الطلب غير موجود</p>";
  include "partials/footer.php";
  exit;
}

// جلب عناصر الطلب (مع صورة اسمية إن وجدت)
$sqlItems = "SELECT oi.quantity, oi.price,
                    p.name AS product_name, p.image AS product_image
             FROM order_items oi
             JOIN products p ON oi.product_id = p.id
             WHERE oi.order_id=?";
$stmt = db()->prepare($sqlItems);
$stmt->execute([$order_id]);
$items = $stmt->fetchAll(PDO::FETCH_ASSOC);

// مساعد صورة مصغرة للمنتج
function product_thumb(?string $rel): string {
  if (!$rel) return "../assets/img/placeholder-hero.jpg";
  // دعم المسارات المخزنة كـ uploads/... أو اسم ملف فقط
  $rel = (strpos($rel, 'uploads/') === 0) ? $rel : ('uploads/products/'.ltrim($rel, '/'));
  $abs = dirname(__DIR__) . '/' . ltrim($rel, '/');
  return is_file($abs) ? ('../' . ltrim($rel, '/')) : "../assets/img/placeholder-hero.jpg";
}

// تنسيق الحالة كشارة
function status_badge(string $st): string {
  $s = strtolower(trim($st));
  $map = [
    'pending'   => ['قيد المراجعة', 'bg:#f59e0b;grad:linear-gradient(145deg,#f59e0b,#fbbf24);txt:#0f0f0f'],
    'paid'      => ['مدفوع',       'bg:#22c55e;grad:linear-gradient(145deg,#22c55e,#86efac);txt:#0b1d10'],
    'approved'  => ['مؤكّد',       'bg:#22c55e;grad:linear-gradient(145deg,#22c55e,#86efac);txt:#0b1d10'],
    'rejected'  => ['مرفوض',       'bg:#ef4444;grad:linear-gradient(145deg,#ef4444,#f87171);txt:#0f0f0f'],
    'shipped'   => ['تم الشحن',    'bg:#38bdf8;grad:linear-gradient(145deg,#38bdf8,#67e8f9);txt:#0b1b1f'],
    'completed' => ['مكتمل',       'bg:#a78bfa;grad:linear-gradient(145deg,#8b5cf6,#a78bfa);txt:#0f0f0f'],
  ];
  $d = $map[$s] ?? [$st, 'bg:#30353b;grad:#30353b;txt:#eaeaea'];
  [$label, $style] = $d;
  // نستخرج اللون من الستايل
  $grad = 'linear-gradient(145deg,#b68f2a,#d4af37,#c8a951)';
  $txt  = '#0f0f0f';
  if (preg_match('/grad:([^;]+)/', $style, $m)) $grad = $m[1];
  if (preg_match('/txt:([^;]+)/',  $style, $m)) $txt  = $m[1];
  return '<span class="st-badge" style="background:'.$grad.';color:'.$txt.'">'.e($label).'</span>';
}

// هل الإيصال صورة؟
$receiptRel = (string)($order['receipt'] ?? '');
$receiptPath = $receiptRel ? ('../uploads/receipts/' . basename($receiptRel)) : '';
$ext = strtolower(pathinfo($receiptPath, PATHINFO_EXTENSION));
$isImage = in_array($ext, ['jpg','jpeg','png','webp','gif']);

// تجميعة الإجمالي من العناصر للتأكيد (يمكن أن تختلف عن o.total إن كانت هناك خصومات)
$calc_total = 0.0;
foreach ($items as $it) {
  $calc_total += ((float)$it['price'] * (int)$it['quantity']);
}
?>
<style>
:root{
  --gold:#d4af37; --ink:#eaeaea; --muted:#9aa7b1; --bg:#0b0b0b; --card:#121212;
}
.ord-wrap{width:min(1200px,95%);margin:28px auto;font-family:'Cairo',system-ui}
.hx{display:flex;justify-content:space-between;align-items:center;margin-bottom:14px}
.hx h2{margin:0;font-weight:900}
.st-badge{display:inline-block;padding:8px 12px;border-radius:999px;font-weight:900}
.cards{display:grid;grid-template-columns:1.1fr 0.9fr;gap:14px}
@media(max-width:980px){.cards{grid-template-columns:1fr}}
.card{background:var(--card);border:1px solid rgba(212,175,55,.45);border-radius:14px;padding:16px;box-shadow:0 12px 26px rgba(0,0,0,.35)}
.kv{display:grid;grid-template-columns:160px 1fr;gap:10px;margin:6px 0}
.kv .k{color:var(--muted)}
.sep{height:1px;background:linear-gradient(90deg,transparent,rgba(212,175,55,.35),transparent);margin:10px 0}

.tbl{width:100%;border-collapse:separate;border-spacing:0 10px}
.tbl thead th{color:var(--gold);font-weight:800;text-align:right;padding:10px;border-bottom:1px solid rgba(212,175,55,.25);white-space:nowrap}
.tbl tbody tr{background:#151515;border:1px solid rgba(212,175,55,.25);border-radius:12px;box-shadow:0 8px 18px rgba(0,0,0,.35)}
.tbl tbody td{padding:10px;white-space:nowrap;vertical-align:middle}
.tbl tbody tr>td:first-child{border-radius:12px 0 0 12px}
.tbl tbody tr>td:last-child{border-radius:0 12px 12px 0}
.thumb{width:64px;height:64px;object-fit:cover;border-radius:10px;border:1px solid rgba(212,175,55,.35);background:#000}
.tright{text-align:left}
.total-line{display:flex;justify-content:flex-end;gap:10px;margin-top:8px}
.total-chip{display:inline-block;padding:10px 14px;border-radius:12px;font-weight:900;background:linear-gradient(145deg,#b68f2a,#d4af37,#c8a951);color:#0f0f0f}

.receipt{display:grid;grid-template-columns:1fr;gap:10px}
.receipt .img{max-width:100%;height:auto;border-radius:12px;border:1px solid rgba(212,175,55,.35);box-shadow:0 10px 24px rgba(0,0,0,.35)}
.actions{display:flex;gap:8px;flex-wrap:wrap}
.btn{display:inline-flex;align-items:center;gap:8px;padding:10px 14px;border-radius:10px;border:0;cursor:pointer;font-weight:800;text-decoration:none}
.btn-dark{background:#1f2937;color:#eaeaea;border:1px solid #374151}
.btn-gold{background:linear-gradient(145deg,#b68f2a,#d4af37,#c8a951);color:#0f0f0f}
.note{color:var(--muted);font-size:13px}
</style>

<div class="ord-wrap">
  <div class="hx">
    <h2>🧾 تفاصيل الطلب #<?= (int)$order['id'] ?></h2>
    <div class="actions">
      <?= status_badge((string)$order['status']) ?>
      <?php if ($receiptPath): ?>
        <a class="btn btn-dark" href="<?= e($receiptPath) ?>" target="_blank"><i class="fa-solid fa-paperclip"></i> عرض الإيصال</a>
      <?php endif; ?>
      <a class="btn btn-dark" href="orders.php"><i class="fa-solid fa-rotate-left"></i> رجوع</a>
    </div>
  </div>

  <div class="cards">
    <!-- معلومات الطلب والعميل -->
    <div class="card">
      <h3 style="margin:0 0 8px">معلومات أساسية</h3>
      <div class="kv"><div class="k">الحالة</div><div><?= status_badge((string)$order['status']) ?></div></div>
      <div class="kv"><div class="k">المبلغ الكلي</div><div><?= number_format((float)$order['total'], 2) ?> ر.س</div></div>
      <div class="kv"><div class="k">تاريخ الطلب</div><div><?= e(date('Y-m-d H:i', strtotime((string)$order['created_at']))) ?></div></div>

      <div class="sep"></div>

      <h3 style="margin:0 0 8px">👤 بيانات العميل</h3>
      <div class="kv"><div class="k">الاسم</div><div><?= e($order['user_name']) ?></div></div>
      <div class="kv"><div class="k">البريد</div><div><a href="mailto:<?= e($order['email']) ?>" style="color:#93c5fd"><?= e($order['email']) ?></a></div></div>
      <div class="kv"><div class="k">الجوال</div><div><a href="tel:<?= e($order['phone']) ?>" style="color:#93c5fd"><?= e($order['phone']) ?></a></div></div>

      <div class="sep"></div>

      <h3 style="margin:0 0 8px">🏦 الحساب البنكي</h3>
      <div class="kv"><div class="k">البنك</div><div><?= e($order['bank_name']) ?></div></div>
      <div class="kv"><div class="k">اسم الحساب</div><div><?= e($order['account_holder']) ?></div></div>
      <div class="kv"><div class="k">IBAN</div><div class="note"><?= e($order['iban']) ?></div></div>
    </div>

    <!-- إيصال -->
    <div class="card">
      <h3 style="margin:0 0 8px">📑 الإيصال</h3>
      <?php if ($receiptPath): ?>
        <?php if ($isImage): ?>
          <div class="receipt">
            <img class="img" src="<?= e($receiptPath) ?>" alt="إيصال تحويل">
            <a class="btn btn-gold" href="<?= e($receiptPath) ?>" target="_blank"><i class="fa-solid fa-up-right-from-square"></i> فتح بالحجم الكامل</a>
          </div>
        <?php else: ?>
          <p class="note">الملف ليس صورة (<?= e(strtoupper($ext)) ?>). <a class="btn btn-gold" href="<?= e($receiptPath) ?>" target="_blank"><i class="fa-solid fa-file"></i> فتح الإيصال</a></p>
        <?php endif; ?>
      <?php else: ?>
        <p class="note">— لا يوجد إيصال مرفوع.</p>
      <?php endif; ?>
    </div>
  </div>

  <!-- جدول المنتجات -->
  <div class="card" style="margin-top:14px">
    <h3 style="margin:0 0 10px">📦 المنتجات</h3>
    <div style="overflow:auto">
      <table class="tbl">
        <thead>
          <tr>
            <th>#</th>
            <th>الصورة</th>
            <th>المنتج</th>
            <th>الكمية</th>
            <th>سعر الوحدة</th>
            <th>الإجمالي</th>
          </tr>
        </thead>
        <tbody>
          <?php
          $i = 1;
          foreach ($items as $it):
            $sub = (float)$it['price'] * (int)$it['quantity'];
          ?>
            <tr>
              <td><?= $i++ ?></td>
              <td><img class="thumb" src="<?= e(product_thumb($it['product_image'] ?? null)) ?>" alt=""></td>
              <td><span style="max-width:320px;display:inline-block;overflow:hidden;text-overflow:ellipsis;vertical-align:bottom"><?= e($it['product_name']) ?></span></td>
              <td><?= (int)$it['quantity'] ?></td>
              <td><?= number_format((float)$it['price'], 2) ?> ر.س</td>
              <td><?= number_format($sub, 2) ?> ر.س</td>
            </tr>
          <?php endforeach; ?>
          <?php if (!$items): ?>
            <tr><td colspan="6" style="text-align:center;color:#aaa">لا توجد عناصر في هذا الطلب.</td></tr>
          <?php endif; ?>
        </tbody>
      </table>
    </div>

    <div class="total-line">
      <span class="total-chip">إجمالي العناصر المحسوب: <?= number_format($calc_total, 2) ?> ر.س</span>
      <span class="total-chip">إجمالي الطلب (من الحقل): <?= number_format((float)$order['total'], 2) ?> ر.س</span>
    </div>
    <?php if (abs($calc_total - (float)$order['total']) > 0.01): ?>
      <p class="note" style="margin-top:8px">تنبيه: يوجد فرق بين مجموع العناصر والإجمالي المسجّل (قد يكون بسبب رسوم/خصومات).</p>
    <?php endif; ?>
  </div>
</div>

<?php include "partials/footer.php"; ?>
