<?php
require_once "../config/db.php";
require_once "../includes/auth.php";
include "partials/header.php";

$id = $_GET['id'] ?? 0;
$stmt = db()->prepare("SELECT o.*, u.name AS user_name, p.name AS product_name
                       FROM orders o
                       JOIN users u ON o.user_id=u.id
                       JOIN products p ON o.product_id=p.id
                       WHERE o.id=?");
$stmt->execute([$id]);
$order = $stmt->fetch();

if (!$order) {
    die("الطلب غير موجود");
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $status = $_POST['status'];
    $stmt = db()->prepare("UPDATE orders SET status=? WHERE id=?");
    $stmt->execute([$status, $id]);
    header("Location: orders.php");
    exit;
}
?>
<div class="admin-content">
  <h2>تحديث حالة الطلب</h2>
  <form method="post" class="form">
    <p><strong>العميل:</strong> <?= htmlspecialchars($order['user_name']) ?></p>
    <p><strong>المنتج:</strong> <?= htmlspecialchars($order['product_name']) ?></p>
    <p><strong>الإجمالي:</strong> <?= number_format($order['total']) ?> ريال</p>

    <label>الحالة</label>
    <select name="status">
      <option value="pending" <?= $order['status']=='pending'?'selected':'' ?>>معلق</option>
      <option value="paid" <?= $order['status']=='paid'?'selected':'' ?>>مدفوع</option>
      <option value="shipped" <?= $order['status']=='shipped'?'selected':'' ?>>تم الشحن</option>
      <option value="completed" <?= $order['status']=='completed'?'selected':'' ?>>مكتمل</option>
      <option value="cancelled" <?= $order['status']=='cancelled'?'selected':'' ?>>ملغي</option>
    </select>

    <button type="submit" class="btn">تحديث</button>
  </form>
</div>
<?php include "partials/footer.php"; ?>
