<?php
// admin/messages.php
require_once __DIR__ . '/../config/db.php';

// TODO: تحقق من جلسة المشرف
// session_start(); if (empty($_SESSION['admin'])) { header('Location: login.php'); exit; }

/* إنشاء الجدول إذا لم يوجد (نفس جدول الصفحة الأمامية) */
db()->exec("
CREATE TABLE IF NOT EXISTS contact_messages (
  id INT AUTO_INCREMENT PRIMARY KEY,
  name VARCHAR(120) NOT NULL,
  email VARCHAR(160) DEFAULT NULL,
  phone VARCHAR(60) DEFAULT NULL,
  subject VARCHAR(200) DEFAULT NULL,
  message TEXT,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
");

session_start();
if (empty($_SESSION['csrf'])) $_SESSION['csrf'] = bin2hex(random_bytes(16));
$csrf = $_SESSION['csrf'];

$msg = '';
if (isset($_GET['delete'], $_GET['csrf']) && hash_equals($_SESSION['csrf'], $_GET['csrf'])) {
  db()->prepare("DELETE FROM contact_messages WHERE id=?")->execute([(int)$_GET['delete']]);
  $msg = 'تم حذف الرسالة.';
}

/* قراءة */
$rows = db()->query("SELECT * FROM contact_messages ORDER BY id DESC")->fetchAll(PDO::FETCH_ASSOC);
$view = null;
if (isset($_GET['view'])) {
  $st = db()->prepare("SELECT * FROM contact_messages WHERE id=?");
  $st->execute([(int)$_GET['view']]);
  $view = $st->fetch(PDO::FETCH_ASSOC);
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="utf-8">
<title>لوحة التحكم - رسائل التواصل</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
<style>
@import url('https://fonts.googleapis.com/css2?family=Cairo:wght@400;600;800&display=swap');
*{box-sizing:border-box} body{margin:0;background:#0b0b0b;color:#eaeaea;font-family:'Cairo',system-ui}
.wrap{width:min(1100px,95%);margin:30px auto}
h1{margin:0 0 18px}
.card{background:#121212;border:1px solid rgba(212,175,55,.45);border-radius:14px;padding:16px;box-shadow:0 12px 26px rgba(0,0,0,.35);margin-bottom:18px}
table{width:100%;border-collapse:collapse}
th,td{padding:10px;border-bottom:1px solid #232323;text-align:right}
th{color:#d4af37}
.btn{padding:8px 12px;border-radius:8px;border:0;cursor:pointer}
.btn-dark{background:#1f2937;color:#eaeaea}
.msg{margin-bottom:10px;color:#b8f7c8;background:#0f2a17;border:1px solid #1d7a41;padding:8px 10px;border-radius:8px}
.badge{padding:4px 8px;border-radius:8px;background:#0f172a;border:1px solid #334155}
pre{white-space:pre-wrap;word-break:break-word}
</style>
</head>
<body>
<div class="wrap">
  <h1><i class="fa-solid fa-inbox"></i> رسائل التواصل</h1>
  <?php if ($msg): ?><div class="msg"><?= htmlspecialchars($msg) ?></div><?php endif; ?>

  <div class="card">
    <h3>القائمة</h3>
    <table>
      <thead>
        <tr>
          <th>#</th><th>الاسم</th><th>البريد</th><th>الهاتف</th><th>الموضوع</th><th>التاريخ</th><th>تحكم</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach($rows as $r): ?>
        <tr>
          <td><?= (int)$r['id'] ?></td>
          <td><?= htmlspecialchars($r['name']) ?></td>
          <td><?= htmlspecialchars($r['email']) ?: '-' ?></td>
          <td><?= htmlspecialchars($r['phone']) ?: '-' ?></td>
          <td><?= htmlspecialchars($r['subject']) ?: '-' ?></td>
          <td><span class="badge"><?= htmlspecialchars($r['created_at']) ?></span></td>
          <td>
            <a class="btn btn-dark" href="?view=<?= (int)$r['id'] ?>"><i class="fa-solid fa-eye"></i> عرض</a>
            <a class="btn btn-dark" href="?delete=<?= (int)$r['id'] ?>&csrf=<?= $csrf ?>" onclick="return confirm('حذف الرسالة نهائيًا؟')"><i class="fa-solid fa-trash"></i> حذف</a>
          </td>
        </tr>
        <?php endforeach; ?>
        <?php if (!$rows): ?><tr><td colspan="7" style="text-align:center;color:#aaa">لا توجد رسائل</td></tr><?php endif; ?>
      </tbody>
    </table>
  </div>

  <?php if ($view): ?>
  <div class="card">
    <h3>عرض الرسالة #<?= (int)$view['id'] ?></h3>
    <p><b>الاسم:</b> <?= htmlspecialchars($view['name']) ?></p>
    <p><b>البريد:</b> <?= htmlspecialchars($view['email']) ?: '-' ?></p>
    <p><b>الهاتف:</b> <?= htmlspecialchars($view['phone']) ?: '-' ?></p>
    <p><b>الموضوع:</b> <?= htmlspecialchars($view['subject']) ?: '-' ?></p>
    <p><b>التاريخ:</b> <?= htmlspecialchars($view['created_at']) ?></p>
    <hr>
    <pre><?= htmlspecialchars($view['message']) ?></pre>
    <div style="margin-top:10px">
      <a class="btn btn-dark" href="mailto:<?= htmlspecialchars($view['email']) ?>"><i class="fa-solid fa-reply"></i> رد بالبريد</a>
      <a class="btn btn-dark" href="messages.php">إغلاق</a>
    </div>
  </div>
  <?php endif; ?>

</div>
</body>
</html>
