<?php
if (session_status()===PHP_SESSION_NONE) session_start();
require_once "../config/db.php";
require_once "../includes/auth.php";
include "partials/header.php";

// CSRF protection
if (empty($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}

$uploadDir = __DIR__ . '/../uploads/blog/';
if (!is_dir($uploadDir)) @mkdir($uploadDir, 0775, true);

$msg = '';
if ($_SERVER['REQUEST_METHOD']==='POST') {
    // CSRF validation
    if (!isset($_POST['csrf_token']) || !hash_equals($_SESSION['csrf_token'], $_POST['csrf_token'])) {
        die('طلب غير مصرح به');
    }
    
    $title    = trim($_POST['title'] ?? '');
    $summary  = trim($_POST['summary'] ?? '');
    $details  = trim($_POST['details'] ?? '');
    $status   = isset($_POST['status']) ? 1 : 0;

    $image = null;
    if (!empty($_FILES['image']['name']) && $_FILES['image']['error'] === UPLOAD_ERR_OK) {
        $ext = strtolower(pathinfo($_FILES['image']['name'], PATHINFO_EXTENSION));
        $allowed = ['jpg','jpeg','png','webp'];
        
        if (!in_array($ext, $allowed)) {
            $msg = 'صيغة الصورة غير مسموحة. المسموح: ' . implode(', ', $allowed);
        } else {
            // Verify actual file type
            $finfo = finfo_open(FILEINFO_MIME_TYPE);
            $mime = finfo_file($finfo, $_FILES['image']['tmp_name']);
            finfo_close($finfo);
            
            $allowed_mimes = ['image/jpeg', 'image/png', 'image/webp'];
            if (!in_array($mime, $allowed_mimes)) {
                $msg = 'نوع الملف غير مسموح';
            } else {
                $image = 'blog_'.date('Ymd_His').'_'.bin2hex(random_bytes(3)).'.'.$ext;
                if (!move_uploaded_file($_FILES['image']['tmp_name'], $uploadDir.$image)) {
                    $msg = 'فشل في رفع الصورة';
                }
            }
        }
    }

    if (!$msg && !empty($title)) {
        try {
            $q = "INSERT INTO blog_posts(title,summary,details,image,status) VALUES(?,?,?,?,?)";
            db()->prepare($q)->execute([$title,$summary,$details,$image,$status]);
            header('Location: blog.php'); 
            exit;
        } catch (PDOException $e) {
            $msg = 'حدث خطأ في حفظ البيانات';
        }
    } elseif (empty($title)) {
        $msg = 'العنوان مطلوب';
    }
}
?>
<!doctype html><html lang="ar" dir="rtl"><head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1">
<title>إضافة مقال</title>
<style>
/* نفس الستايل الحالي */
</style>
</head><body>
<div class="wrap">
  <h1>إضافة مقال</h1>
  <?php if ($msg): ?><div class="err"><?= htmlspecialchars($msg) ?></div><?php endif; ?>
  <form class="card" method="post" enctype="multipart/form-data">
    <input type="hidden" name="csrf_token" value="<?= htmlspecialchars($_SESSION['csrf_token'] ?? '') ?>">
    
    <label>العنوان *</label>
    <input type="text" name="title" required value="<?= htmlspecialchars($_POST['title'] ?? '') ?>">

    <label>النبذة</label>
    <textarea name="summary" placeholder="نبذة قصيرة عن المقال"><?= htmlspecialchars($_POST['summary'] ?? '') ?></textarea>

    <label>التفاصيل</label>
    <textarea name="details" placeholder="نص المقال بالتفصيل"><?= htmlspecialchars($_POST['details'] ?? '') ?></textarea>

    <label>الصورة</label>
    <input type="file" name="image" accept=".jpg,.jpeg,.png,.webp">
    <div class="note">يفضل صورة عريضة 1200×600 (WebP أسرع).</div>

    <label><input type="checkbox" name="status" <?= isset($_POST['status']) ? 'checked' : 'checked' ?>> منشور</label>

    <button class="btn" type="submit">حفظ</button>
    <a class="btn" style="background:#1f2937;color:#fff" href="blog.php">عودة</a>
  </form>
</div>
<?php include "partials/footer.php"; ?>
</body></html>