<?php
if (session_status()===PHP_SESSION_NONE) session_start();
require_once "../config/db.php";
require_once "../includes/auth.php";
include "partials/header.php";
// إن كانت لديك حماية دخول، فعّلها هنا:
// if (empty($_SESSION['user_id'])) { header('Location: ../login.php'); exit; }

$list = db()->query("SELECT * FROM blog_posts ORDER BY created_at DESC, id DESC")->fetchAll();
?>
<!doctype html><html lang="ar" dir="rtl"><head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1">
<title>إدارة المدونة</title>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
<style>
:root{--line:#2a2a2a;--gold:#D4AF37}
body{background:#0a0a0a;color:#e0e0e0;font-family:'Cairo','Segoe UI',Tahoma,sans-serif;margin:0;padding:24px}
.wrap{max-width:1100px;margin:0 auto}
h1{margin:0 0 18px}
.btn{background:var(--gold);color:#000;border:0;border-radius:10px;padding:10px 14px;font-weight:700;text-decoration:none}
.table{width:100%;border-collapse:collapse;background:#111;border:1px solid var(--line);border-radius:12px;overflow:hidden}
th,td{padding:10px 12px;border-bottom:1px solid var(--line);vertical-align:middle}
th{background:#0f1320;color:#cbd5e1;text-align:right}
tr:hover td{background:#0f0f0f}
.actions a{margin-inline-start:8px}
.cover{width:140px;height:80px;object-fit:cover;border-radius:8px;border:1px solid #222}
.status{padding:2px 8px;border-radius:999px;font-size:.85rem}
.on{background:#064e3b;color:#d1fae5}
.off{background:#4b5563;color:#e5e7eb}
.topbar{display:flex;justify-content:space-between;align-items:center;margin-bottom:16px}
</style>
</head><body>
<div class="wrap">
  <div class="topbar">
    <h1>إدارة المدونة</h1>
    <a class="btn" href="blog_add.php"><i class="fa fa-plus"></i> مقال جديد</a>
  </div>

  <table class="table">
    <thead>
      <tr>
        <th>#</th><th>الصورة</th><th>العنوان</th><th>النبذة</th><th>الحالة</th><th>التاريخ</th><th>إجراءات</th>
      </tr>
    </thead>
    <tbody>
      <?php foreach ($list as $row): ?>
        <tr>
          <td><?= (int)$row['id'] ?></td>
          <td><?php if(!empty($row['image'])): ?><img class="cover" src="../<?= (strpos($row['image'],'/')===false?'uploads/':'').htmlspecialchars($row['image']) ?>" alt=""><?php else: ?>—<?php endif; ?></td>
          <td><?= htmlspecialchars($row['title']) ?></td>
          <td style="max-width:280px;white-space:nowrap;overflow:hidden;text-overflow:ellipsis"><?= htmlspecialchars($row['summary']) ?></td>
          <td><span class="status <?= $row['status']?'on':'off' ?>"><?= $row['status']?'منشور':'مخفي' ?></span></td>
          <td><?= htmlspecialchars($row['created_at']) ?></td>
          <td class="actions">
            <a href="blog_edit.php?id=<?= (int)$row['id'] ?>" title="تعديل"><i class="fa fa-pen"></i></a>
            <a href="blog_delete.php?id=<?= (int)$row['id'] ?>" title="حذف" onclick="return confirm('حذف المقال نهائيًا؟')"><i class="fa fa-trash"></i></a>
          </td>
        </tr>
      <?php endforeach; ?>
      <?php if (!$list): ?><tr><td colspan="7" style="text-align:center;color:#aaa">لا توجد مقالات بعد.</td></tr><?php endif; ?>
    </tbody>
  </table>
</div>

</body></html>
<?php include "partials/footer.php"; ?>
