<?php
require_once "../config/db.php";
require_once "../includes/auth.php";

$id = intval($_GET['id'] ?? 0);
if ($id <= 0) {
    header("Location: about.php");
    exit;
}

// جلب بيانات القسم
$stmt = db()->prepare("SELECT * FROM about_sections WHERE id=? LIMIT 1");
$stmt->execute([$id]);
$section = $stmt->fetch();

if (!$section) {
    echo "<p style='color:red; text-align:center;'>❌ القسم غير موجود</p>";
    exit;
}

// حفظ التعديلات
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $title = $_POST['title'] ?? '';
    $content = $_POST['content'] ?? '';
    $icon = $_POST['icon'] ?? 'fas fa-gem';
    $sort = intval($_POST['sort_order'] ?? 0);

    $stmt = db()->prepare("UPDATE about_sections SET title=?, content=?, icon=?, sort_order=? WHERE id=?");
    $stmt->execute([$title, $content, $icon, $sort, $id]);

    header("Location: about.php?msg=updated");
    exit;
}

include "partials/header.php";
?>

<div class="admin-content">
  <h2>✏️ تعديل قسم: <?= htmlspecialchars($section['title']) ?></h2>

  <form method="post">
    <label>العنوان:</label>
    <input type="text" name="title" value="<?= htmlspecialchars($section['title']) ?>" required>

    <label>المحتوى:</label>
    <textarea name="content" rows="5" required><?= htmlspecialchars($section['content']) ?></textarea>

    <label>الأيقونة (FontAwesome):</label>
    <input type="text" name="icon" value="<?= htmlspecialchars($section['icon']) ?>">

    <label>الترتيب:</label>
    <input type="number" name="sort_order" value="<?= intval($section['sort_order']) ?>">

    <button type="submit" class="btn">💾 حفظ التعديلات</button>
  </form>
</div>

<?php include "partials/footer.php"; ?>
