<?php
// admin/about.php
require_once "../config/db.php";
require_once "../includes/auth.php";
include "partials/header.php";

// بداية الجلسة بشكل آمن
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

if (empty($_SESSION['csrf'])) $_SESSION['csrf'] = bin2hex(random_bytes(16));
$csrf = $_SESSION['csrf'];

/* ========= إنشاء الجداول ========= */
db()->exec("
CREATE TABLE IF NOT EXISTS about_hero (
  id TINYINT PRIMARY KEY DEFAULT 1,
  title VARCHAR(200) NOT NULL,
  subtitle TEXT,
  bg_image VARCHAR(255) DEFAULT NULL,
  updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
CREATE TABLE IF NOT EXISTS about_intro (
  id TINYINT PRIMARY KEY DEFAULT 1,
  body TEXT,
  updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
CREATE TABLE IF NOT EXISTS about_rmv (
  id INT AUTO_INCREMENT PRIMARY KEY,
  kind ENUM('vision','mission','values') NOT NULL,
  title VARCHAR(200) NOT NULL,
  description TEXT,
  chips TEXT,
  sort INT DEFAULT 0,
  status TINYINT(1) DEFAULT 1,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
CREATE TABLE IF NOT EXISTS about_counters (
  id INT AUTO_INCREMENT PRIMARY KEY,
  label VARCHAR(200) NOT NULL,
  number INT NOT NULL DEFAULT 0,
  sort INT DEFAULT 0,
  status TINYINT(1) DEFAULT 1
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
CREATE TABLE IF NOT EXISTS about_timeline (
  id INT AUTO_INCREMENT PRIMARY KEY,
  title VARCHAR(200) NOT NULL,
  description TEXT,
  sort INT DEFAULT 0,
  status TINYINT(1) DEFAULT 1
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
CREATE TABLE IF NOT EXISTS about_team (
  id INT AUTO_INCREMENT PRIMARY KEY,
  name VARCHAR(160) NOT NULL,
  role VARCHAR(160) DEFAULT NULL,
  photo VARCHAR(255) DEFAULT NULL,
  sort INT DEFAULT 0,
  status TINYINT(1) DEFAULT 1
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
CREATE TABLE IF NOT EXISTS about_faq (
  id INT AUTO_INCREMENT PRIMARY KEY,
  question VARCHAR(255) NOT NULL,
  answer TEXT,
  sort INT DEFAULT 0,
  status TINYINT(1) DEFAULT 1
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
CREATE TABLE IF NOT EXISTS about_cta (
  id TINYINT PRIMARY KEY DEFAULT 1,
  title VARCHAR(200) NOT NULL,
  subtitle TEXT,
  btn_text VARCHAR(120) DEFAULT NULL,
  btn_link VARCHAR(255) DEFAULT NULL,
  updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
");

/* ========= تهيئة بمحتوى افتراضي (مرة واحدة) ========= */
function table_empty($name){
  $c = db()->query("SELECT COUNT(*) FROM {$name}")->fetchColumn();
  return !$c;
}
if (table_empty('about_hero')) {
  db()->exec("INSERT INTO about_hero (id,title,subtitle,bg_image) VALUES (1,'عن الكندي للذهب والمجوهرات','أكثر من أربعة عقود من الثقة والجودة في عالم الذهب، بخبرات تمتد من التصنيع إلى الاستثمار وخدمات ما بعد البيع.','assets/img/about-hero.jpg')");
}
if (table_empty('about_intro')) {
  db()->exec("INSERT INTO about_intro (id,body) VALUES (1,'تأسست شركة صالح محمد الكندي بن محفوظ ومشاركوه عام 1980م لتكون إحدى الشركات الرائدة والمتخصصة في مجال سبائك الذهب في المملكة العربية السعودية. على مدى سنوات طويلة، رسّخنا مكانتنا لدى المستثمرين والمهتمين بالسبائك الذهبية عبر الجودة، الشفافية، وخدمات عملاء متميزة. نفخر بكوننا الموزع الرئيسي المعتمد لسبائك PAMP السويسرية في المملكة.')");
}
if (table_empty('about_rmv')) {
  $st = db()->prepare("INSERT INTO about_rmv(kind,title,description,chips,sort,status) VALUES (?,?,?,?,?,1)");
  $st->execute(['vision','الرؤية','الريادة في سوق السبائك والمجوهرات عبر معايير عالمية، وتقديم قيمة مستدامة لعملائنا وشركائنا.',null,0]);
  $st->execute(['mission','الرسالة','توفير منتجات ذهبية موثوقة بخيارات متنوعة، مع تحديث أسعار لحظي، وضمان جودة وشهادات أصلية.',null,1]);
  $st->execute(['values','القيم',null,"الأمانة\nالشفافية\nالجودة\nالابتكار\nالعملاء أولًا",2]);
}
if (table_empty('about_counters')) {
  $st = db()->prepare("INSERT INTO about_counters(label,number,sort,status) VALUES (?,?,?,1)");
  $st->execute(['عامًا من الخبرة',45,0]);
  $st->execute(['عميل سعيد',50000,1]);
  $st->execute(['منتج وقطعة',1500,2]);
  $st->execute(['شريك موثوق',20,3]);
}
if (table_empty('about_timeline')) {
  $st = db()->prepare("INSERT INTO about_timeline(title,description,sort,status) VALUES (?,?,?,1)");
  $st->execute(['1980 — التأسيس','انطلقت الشركة على يد المؤسس صالح محمد الكندي بن محفوظ لتلبية احتياجات السوق المحلي من السبائك الذهبية.',0]);
  $st->execute(['1995 — التوسّع','افتتاح قنوات توزيع جديدة وتوسعة الشبكة اللوجستية لتغطية مناطق أوسع داخل المملكة.',1]);
  $st->execute(['2010 — الاعتماد','الحصول على اعتماد التوزيع الرسمي لسبائك PAMP السويسرية في المملكة.',2]);
  $st->execute(['2020 — التحوّل الرقمي','إطلاق خدمات إلكترونية ومزامنة الأسعار لحظيًا لتجربة تسوّق وشراء أكثر مرونة وشفافية.',3]);
}
if (table_empty('about_team')) {
  $st = db()->prepare("INSERT INTO about_team(name,role,photo,sort,status) VALUES (?,?,?,?,1)");
  $st->execute(['أحمد السلمي','المدير العام','assets/img/team1.jpg',0]);
  $st->execute(['نورة الشهري','مديرة الجودة','assets/img/team2.jpg',1]);
  $st->execute(['علي العتيبي','رئيس المشتريات','assets/img/team3.jpg',2]);
  $st->execute(['شهد القحطاني','قائدة تجربة العملاء','assets/img/team4.jpg',3]);
}
if (table_empty('about_faq')) {
  $st = db()->prepare("INSERT INTO about_faq(question,answer,sort,status) VALUES (?,?,?,1)");
  $st->execute(['هل تقدمون شهادات اعتماد مع السبائك؟','نعم، جميع السبائك مرفقة بشهادات اعتماد رسمية تؤكد النقاء والوزن والمصدر.',0]);
  $st->execute(['كيف يتم حساب السعر النهائي عند الشراء؟','يعتمد على سعر الجرام المحدث لحظيًا × وزن القطعة، وقد تُضاف أجور مصنعية حسب المنتج.',1]);
  $st->execute(['هل يمكن الشحن لجميع مناطق المملكة؟','نعم، نوفر شحنًا آمنًا مع تغليف محكم وتتبع للطلب حتى يصل إليك.',2]);
}
if (table_empty('about_cta')) {
  db()->exec("INSERT INTO about_cta (id,title,subtitle,btn_text,btn_link) VALUES (1,'جاهز للاستثمار بثقة؟','اطّلع على منتجاتنا الآن واختر ما يناسبك من سبائك وقطع ذهبية أصلية.','اذهب للمنتجات','gold.php')");
}

/* ========= أدوات مساعدة ========= */
function upload_about_file($file){
  if (empty($file['name']) || $file['error'] !== UPLOAD_ERR_OK) return null;
  $ext = strtolower(pathinfo($file['name'], PATHINFO_EXTENSION));
  if (!in_array($ext, ['png','jpg','jpeg','webp','svg'])) return null;
  $dir = __DIR__ . '/../uploads/about';
  if (!is_dir($dir)) @mkdir($dir, 0775, true);
  $name = 'about_' . date('Ymd_His') . '_' . bin2hex(random_bytes(3)) . '.' . $ext;
  $dest = $dir . '/' . $name;
  if (!move_uploaded_file($file['tmp_name'], $dest)) return null;
  return 'uploads/about/' . $name;
}
function ok($t){ return '<div class="msg ok">'.$t.'</div>'; }
function err($t){ return '<div class="msg err">'.$t.'</div>'; }

/* ========= عمليات الحفظ/الحذف ========= */
$tab = $_GET['tab'] ?? 'hero';
$flash = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['csrf']) && hash_equals($_SESSION['csrf'], $_POST['csrf'])) {
  switch ($_POST['scope'] ?? '') {
    case 'hero':
      $title = trim($_POST['title'] ?? '');
      $subtitle = trim($_POST['subtitle'] ?? '');
      $bg = upload_about_file($_FILES['bg_image'] ?? []);
      if ($title) {
        if ($bg) {
          db()->prepare("UPDATE about_hero SET title=?, subtitle=?, bg_image=? WHERE id=1")->execute([$title,$subtitle,$bg]);
        } else {
          db()->prepare("UPDATE about_hero SET title=?, subtitle=? WHERE id=1")->execute([$title,$subtitle]);
        }
        $flash = ok('تم حفظ الهيرو.');
      } else $flash = err('الرجاء إدخال العنوان.');
      $tab='hero';
      break;

    case 'intro':
      $body = trim($_POST['body'] ?? '');
      db()->prepare("UPDATE about_intro SET body=? WHERE id=1")->execute([$body]);
      $flash = ok('تم حفظ المقدّمة.');
      $tab='intro';
      break;

    case 'rmv_create':
      $kind = $_POST['kind'] ?? 'vision';
      $title= trim($_POST['title'] ?? '');
      $desc = trim($_POST['description'] ?? '');
      $chips= trim($_POST['chips'] ?? '');
      $sort = (int)($_POST['sort'] ?? 0);
      $status=(int)($_POST['status'] ?? 1);
      if ($title) {
        db()->prepare("INSERT INTO about_rmv(kind,title,description,chips,sort,status) VALUES (?,?,?,?,?,?)")
          ->execute([$kind,$title,$desc,$chips,$sort,$status]);
        $flash = ok('تم إضافة البطاقة.');
      } else $flash = err('العنوان مطلوب.');
      $tab='rmv';
      break;

    case 'rmv_update':
      $id   = (int)($_POST['id'] ?? 0);
      $kind = $_POST['kind'] ?? 'vision';
      $title= trim($_POST['title'] ?? '');
      $desc = trim($_POST['description'] ?? '');
      $chips= trim($_POST['chips'] ?? '');
      $sort = (int)($_POST['sort'] ?? 0);
      $status=(int)($_POST['status'] ?? 1);
      if ($id && $title) {
        db()->prepare("UPDATE about_rmv SET kind=?, title=?, description=?, chips=?, sort=?, status=? WHERE id=?")
          ->execute([$kind,$title,$desc,$chips,$sort,$status,$id]);
        $flash = ok('تم تحديث البطاقة.');
      }
      $tab='rmv';
      break;

    case 'counter_create':
      $label= trim($_POST['label'] ?? '');
      $number= (int)($_POST['number'] ?? 0);
      $sort = (int)($_POST['sort'] ?? 0);
      $status=(int)($_POST['status'] ?? 1);
      if ($label) {
        db()->prepare("INSERT INTO about_counters(label,number,sort,status) VALUES (?,?,?,?)")
          ->execute([$label,$number,$sort,$status]);
        $flash = ok('تمت إضافة العداد.');
      } else $flash = err('التسمية مطلوبة.');
      $tab='counters';
      break;

    case 'counter_update':
      $id = (int)($_POST['id'] ?? 0);
      $label= trim($_POST['label'] ?? '');
      $number= (int)($_POST['number'] ?? 0);
      $sort = (int)($_POST['sort'] ?? 0);
      $status=(int)($_POST['status'] ?? 1);
      if ($id && $label) {
        db()->prepare("UPDATE about_counters SET label=?, number=?, sort=?, status=? WHERE id=?")
          ->execute([$label,$number,$sort,$status,$id]);
        $flash = ok('تم تحديث العداد.');
      }
      $tab='counters';
      break;

    case 'timeline_create':
      $title= trim($_POST['title'] ?? '');
      $desc = trim($_POST['description'] ?? '');
      $sort = (int)($_POST['sort'] ?? 0);
      $status=(int)($_POST['status'] ?? 1);
      if ($title) {
        db()->prepare("INSERT INTO about_timeline(title,description,sort,status) VALUES (?,?,?,?)")
          ->execute([$title,$desc,$sort,$status]);
        $flash = ok('تمت إضافة محطة.');
      } else $flash = err('العنوان مطلوب.');
      $tab='timeline';
      break;

    case 'timeline_update':
      $id   = (int)($_POST['id'] ?? 0);
      $title= trim($_POST['title'] ?? '');
      $desc = trim($_POST['description'] ?? '');
      $sort = (int)($_POST['sort'] ?? 0);
      $status=(int)($_POST['status'] ?? 1);
      if ($id && $title) {
        db()->prepare("UPDATE about_timeline SET title=?, description=?, sort=?, status=? WHERE id=?")
          ->execute([$title,$desc,$sort,$status,$id]);
        $flash = ok('تم تحديث المحطة.');
      }
      $tab='timeline';
      break;

    case 'team_create':
      $name = trim($_POST['name'] ?? '');
      $role = trim($_POST['role'] ?? '');
      $sort = (int)($_POST['sort'] ?? 0);
      $status=(int)($_POST['status'] ?? 1);
      $photo = upload_about_file($_FILES['photo'] ?? []);
      if ($name) {
        db()->prepare("INSERT INTO about_team(name,role,photo,sort,status) VALUES (?,?,?,?,?)")
          ->execute([$name,$role,$photo,$sort,$status]);
        $flash = ok('تمت إضافة عضو.');
      } else $flash = err('الاسم مطلوب.');
      $tab='team';
      break;

    case 'team_update':
      $id   = (int)($_POST['id'] ?? 0);
      $name = trim($_POST['name'] ?? '');
      $role = trim($_POST['role'] ?? '');
      $sort = (int)($_POST['sort'] ?? 0);
      $status=(int)($_POST['status'] ?? 1);
      $photo = upload_about_file($_FILES['photo'] ?? []);
      if ($id && $name) {
        if ($photo) {
          db()->prepare("UPDATE about_team SET name=?, role=?, photo=?, sort=?, status=? WHERE id=?")
            ->execute([$name,$role,$photo,$sort,$status,$id]);
        } else {
          db()->prepare("UPDATE about_team SET name=?, role=?, sort=?, status=? WHERE id=?")
            ->execute([$name,$role,$sort,$status,$id]);
        }
        $flash = ok('تم تحديث العضو.');
      }
      $tab='team';
      break;

    case 'faq_create':
      $q = trim($_POST['question'] ?? '');
      $a = trim($_POST['answer'] ?? '');
      $sort = (int)($_POST['sort'] ?? 0);
      $status=(int)($_POST['status'] ?? 1);
      if ($q) {
        db()->prepare("INSERT INTO about_faq(question,answer,sort,status) VALUES (?,?,?,?)")
          ->execute([$q,$a,$sort,$status]);
        $flash = ok('تمت إضافة سؤال.');
      } else $flash = err('السؤال مطلوب.');
      $tab='faq';
      break;

    case 'faq_update':
      $id = (int)($_POST['id'] ?? 0);
      $q = trim($_POST['question'] ?? '');
      $a = trim($_POST['answer'] ?? '');
      $sort = (int)($_POST['sort'] ?? 0);
      $status=(int)($_POST['status'] ?? 1);
      if ($id && $q) {
        db()->prepare("UPDATE about_faq SET question=?, answer=?, sort=?, status=? WHERE id=?")
          ->execute([$q,$a,$sort,$status,$id]);
        $flash = ok('تم تحديث السؤال.');
      }
      $tab='faq';
      break;

    case 'cta':
      $title = trim($_POST['title'] ?? '');
      $subtitle = trim($_POST['subtitle'] ?? '');
      $btn_text = trim($_POST['btn_text'] ?? '');
      $btn_link = trim($_POST['btn_link'] ?? '');
      if ($title) {
        db()->prepare("UPDATE about_cta SET title=?, subtitle=?, btn_text=?, btn_link=? WHERE id=1")
          ->execute([$title,$subtitle,$btn_text,$btn_link]);
        $flash = ok('تم حفظ قسم الدعوة للإجراء.');
      } else $flash = err('العنوان مطلوب.');
      $tab='cta';
      break;
  }
}

if (isset($_GET['del']) && isset($_GET['from']) && isset($_GET['csrf']) && hash_equals($_SESSION['csrf'], $_GET['csrf'])) {
  $from = $_GET['from'];
  $id   = (int)$_GET['del'];
  $tbls = ['about_rmv','about_counters','about_timeline','about_team','about_faq'];
  if (in_array($from, $tbls)) {
    db()->prepare("DELETE FROM {$from} WHERE id=?")->execute([$id]);
    $flash = ok('تم الحذف.');
  }
  $tab = str_replace('about_','',$from);
  if ($tab==='rmv') $tab='rmv';
  if ($tab==='counters') $tab='counters';
  if ($tab==='timeline') $tab='timeline';
  if ($tab==='team') $tab='team';
  if ($tab==='faq') $tab='faq';
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="utf-8">
<title>لوحة التحكم — صفحة من نحن</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
<style>
@import url('https://fonts.googleapis.com/css2?family=Cairo:wght@400;600;800&display=swap');
*{box-sizing:border-box}
body{margin:0;background:#0b0b0b;color:#eaeaea;font-family:'Cairo',system-ui}
.wrap{width:min(1200px,95%);margin:26px auto}
h1{margin:0 0 14px}
.tabs{display:flex;gap:8px;flex-wrap:wrap;margin:10px 0 18px}
.tab{display:inline-flex;align-items:center;gap:8px;padding:10px 12px;border-radius:10px;background:#121212;border:1px solid #232323;color:#eaeaea;text-decoration:none}
.tab.active{border-color:rgba(212,175,55,.55);box-shadow:0 6px 16px rgba(0,0,0,.35)}
.card{background:#121212;border:1px solid rgba(212,175,55,.45);border-radius:14px;padding:16px;box-shadow:0 12px 26px rgba(0,0,0,.35);margin-bottom:18px}
label{display:block;margin:8px 0 6px}
input,select,textarea{width:100%;padding:10px 12px;border-radius:10px;border:1px solid rgba(212,175,55,.35);background:#0f0f0f;color:#fff}
textarea{min-height:110px}
.grid{display:grid;gap:12px;grid-template-columns:1fr 1fr}
@media(max-width:800px){.grid{grid-template-columns:1fr}}
.btn{padding:10px 16px;border-radius:10px;border:0;cursor:pointer;font-weight:800}
.btn-gold{background:linear-gradient(145deg,#b68f2a,#d4af37,#c8a951);color:#111}
.btn-dark{background:#1f2937;color:#eaeaea}
table{width:100%;border-collapse:collapse;margin-top:10px}
th,td{padding:10px;border-bottom:1px solid #232323;text-align:right;vertical-align:top}
th{color:#d4af37}
.msg{padding:10px 12px;border-radius:10px;margin-bottom:12px}
.msg.ok{background:#112d1a;border:1px solid #1f7a33;color:#b8f7c8}
.msg.err{background:#3f1d1d;border:1px solid #7f1d1d;color:#fee2e2}
.small{color:#9aa7b1;font-size:12px}
.thumb{width:140px;height:70px;object-fit:cover;background:#0f0f0f;border:1px solid #333;border-radius:8px}
.avatar{width:70px;height:70px;object-fit:cover;background:#0f0f0f;border:1px solid #333;border-radius:50%}
</style>
</head>
<body>
<div class="wrap">
  <h1><i class="fa-solid fa-circle-info"></i> إدارة صفحة من نحن</h1>

  <!-- Tabs -->
  <div class="tabs">
    <?php
      $tabs = [
        'hero'=>'الهيرو','intro'=>'المقدّمة','rmv'=>'الرؤية/الرسالة/القيم',
        'counters'=>'الأرقام','timeline'=>'المسار الزمني','team'=>'الفريق','faq'=>'الأسئلة الشائعة','cta'=>'الدعوة للإجراء'
      ];
      foreach($tabs as $k=>$v){
        $act = $tab===$k?' active':'';
        echo '<a class="tab'.$act.'" href="?tab='.$k.'"><i class="fa-solid fa-angle-left"></i>'.$v.'</a>';
      }
    ?>
  </div>

  <?= $flash ?>

  <?php
  /* ========== HERO ========== */
  if ($tab==='hero'):
    $h = db()->query("SELECT * FROM about_hero WHERE id=1")->fetch(PDO::FETCH_ASSOC);
  ?>
  <div class="card">
    <h3>الهيرو</h3>
    <form method="post" enctype="multipart/form-data">
      <input type="hidden" name="csrf" value="<?= $csrf ?>">
      <input type="hidden" name="scope" value="hero">
      <div class="grid">
        <div>
          <label>العنوان</label>
          <input name="title" value="<?= htmlspecialchars($h['title'] ?? '') ?>" required>
        </div>
        <div>
          <label>الوصف</label>
          <input name="subtitle" value="<?= htmlspecialchars($h['subtitle'] ?? '') ?>">
        </div>
      </div>
      <div style="margin-top:8px">
        <label>خلفية (PNG/JPG/WEBP/SVG)</label>
        <input type="file" name="bg_image" accept=".png,.jpg,.jpeg,.webp,.svg">
        <div class="small">الحالي: <?= htmlspecialchars($h['bg_image'] ?? '—') ?></div>
      </div>
      <div style="margin-top:12px"><button class="btn btn-gold">حفظ</button></div>
    </form>
  </div>
  <?php endif; ?>

  <?php
  /* ========== INTRO ========== */
  if ($tab==='intro'):
    $r = db()->query("SELECT * FROM about_intro WHERE id=1")->fetch(PDO::FETCH_ASSOC);
  ?>
  <div class="card">
    <h3>المقدّمة</h3>
    <form method="post">
      <input type="hidden" name="csrf" value="<?= $csrf ?>">
      <input type="hidden" name="scope" value="intro">
      <label>النص</label>
      <textarea name="body" rows="6"><?= htmlspecialchars($r['body'] ?? '') ?></textarea>
      <div style="margin-top:12px"><button class="btn btn-gold">حفظ</button></div>
    </form>
  </div>
  <?php endif; ?>

  <?php
  /* ========== RMV ========== */
  if ($tab==='rmv'):
    $rows = db()->query("SELECT * FROM about_rmv ORDER BY sort, id DESC")->fetchAll(PDO::FETCH_ASSOC);
  ?>
  <div class="card">
    <h3>إضافة بطاقة (رؤية/رسالة/قيم)</h3>
    <form method="post">
      <input type="hidden" name="csrf" value="<?= $csrf ?>">
      <input type="hidden" name="scope" value="rmv_create">
      <div class="grid">
        <div>
          <label>النوع</label>
          <select name="kind">
            <option value="vision">الرؤية</option>
            <option value="mission">الرسالة</option>
            <option value="values">القيم</option>
          </select>
        </div>
        <div>
          <label>العنوان</label>
          <input name="title" required>
        </div>
      </div>
      <label>الوصف</label>
      <textarea name="description"></textarea>
      <label>القيم (سطر لكل قيمة) — للنوع "القيم"</label>
      <textarea name="chips" placeholder="الأمانة&#10;الشفافية&#10;..."></textarea>
      <div class="grid">
        <div><label>الترتيب</label><input type="number" name="sort" value="0"></div>
        <div><label>الحالة</label><select name="status"><option value="1">مفعل</option><option value="0">معطل</option></select></div>
      </div>
      <div style="margin-top:12px"><button class="btn btn-gold">إضافة</button></div>
    </form>
  </div>

  <div class="card">
    <h3>القائمة</h3>
    <table>
      <thead><tr><th>#</th><th>النوع</th><th>العنوان</th><th>الوصف</th><th>القيم</th><th>ترتيب</th><th>حالة</th><th>تحكم</th></tr></thead>
      <tbody>
        <?php foreach($rows as $x): ?>
        <tr>
          <td><?= (int)$x['id'] ?></td>
          <td><?= $x['kind']==='vision'?'الرؤية':($x['kind']==='mission'?'الرسالة':'القيم') ?></td>
          <td><?= htmlspecialchars($x['title']) ?></td>
          <td><?= nl2br(htmlspecialchars($x['description'])) ?></td>
          <td><pre style="white-space:pre-wrap;margin:0"><?= htmlspecialchars($x['chips']) ?></pre></td>
          <td><?= (int)$x['sort'] ?></td>
          <td><?= $x['status']?'مفعل':'معطل' ?></td>
          <td>
            <details>
              <summary>تعديل</summary>
              <form method="post" style="margin-top:8px">
                <input type="hidden" name="csrf" value="<?= $csrf ?>">
                <input type="hidden" name="scope" value="rmv_update">
                <input type="hidden" name="id" value="<?= (int)$x['id'] ?>">
                <div class="grid">
                  <div>
                    <label>النوع</label>
                    <select name="kind">
                      <option value="vision"<?= $x['kind']==='vision'?' selected':'' ?>>الرؤية</option>
                      <option value="mission"<?= $x['kind']==='mission'?' selected':'' ?>>الرسالة</option>
                      <option value="values"<?= $x['kind']==='values'?' selected':'' ?>>القيم</option>
                    </select>
                  </div>
                  <div><label>العنوان</label><input name="title" value="<?= htmlspecialchars($x['title']) ?>"></div>
                </div>
                <label>الوصف</label><textarea name="description"><?= htmlspecialchars($x['description']) ?></textarea>
                <label>القيم</label><textarea name="chips"><?= htmlspecialchars($x['chips']) ?></textarea>
                <div class="grid">
                  <div><label>الترتيب</label><input type="number" name="sort" value="<?= (int)$x['sort'] ?>"></div>
                  <div><label>الحالة</label>
                    <select name="status"><option value="1"<?= $x['status']?' selected':'' ?>>مفعل</option><option value="0"<?= !$x['status']?' selected':'' ?>>معطل</option></select>
                  </div>
                </div>
                <div style="margin-top:8px">
                  <button class="btn btn-gold">حفظ</button>
                  <a class="btn btn-dark" href="?tab=rmv&del=<?= (int)$x['id'] ?>&from=about_rmv&csrf=<?= $csrf ?>" onclick="return confirm('حذف السجل؟')">حذف</a>
                </div>
              </form>
            </details>
          </td>
        </tr>
        <?php endforeach; if(!$rows): ?>
        <tr><td colspan="8" style="text-align:center;color:#aaa">لا توجد بيانات</td></tr>
        <?php endif; ?>
      </tbody>
    </table>
  </div>
  <?php endif; ?>

  <?php
  /* ========== COUNTERS ========== */
  if ($tab==='counters'):
    $rows = db()->query("SELECT * FROM about_counters ORDER BY sort, id")->fetchAll(PDO::FETCH_ASSOC);
  ?>
  <div class="card">
    <h3>إضافة عداد</h3>
    <form method="post">
      <input type="hidden" name="csrf" value="<?= $csrf ?>">
      <input type="hidden" name="scope" value="counter_create">
      <div class="grid">
        <div><label>التسمية</label><input name="label" required></div>
        <div><label>الرقم</label><input type="number" name="number" value="0"></div>
      </div>
      <div class="grid">
        <div><label>الترتيب</label><input type="number" name="sort" value="0"></div>
        <div><label>الحالة</label><select name="status"><option value="1">مفعل</option><option value="0">معطل</option></select></div>
      </div>
      <div style="margin-top:12px"><button class="btn btn-gold">إضافة</button></div>
    </form>
  </div>
  <div class="card">
    <h3>القائمة</h3>
    <table>
      <thead><tr><th>#</th><th>التسمية</th><th>الرقم</th><th>الترتيب</th><th>الحالة</th><th>تحكم</th></tr></thead>
      <tbody>
        <?php foreach($rows as $x): ?>
        <tr>
          <td><?= (int)$x['id'] ?></td>
          <td><?= htmlspecialchars($x['label']) ?></td>
          <td><?= (int)$x['number'] ?></td>
          <td><?= (int)$x['sort'] ?></td>
          <td><?= $x['status']?'مفعل':'معطل' ?></td>
          <td>
            <details>
              <summary>تعديل</summary>
              <form method="post" style="margin-top:8px">
                <input type="hidden" name="csrf" value="<?= $csrf ?>">
                <input type="hidden" name="scope" value="counter_update">
                <input type="hidden" name="id" value="<?= (int)$x['id'] ?>">
                <div class="grid">
                  <div><label>التسمية</label><input name="label" value="<?= htmlspecialchars($x['label']) ?>"></div>
                  <div><label>الرقم</label><input type="number" name="number" value="<?= (int)$x['number'] ?>"></div>
                </div>
                <div class="grid">
                  <div><label>الترتيب</label><input type="number" name="sort" value="<?= (int)$x['sort'] ?>"></div>
                  <div><label>الحالة</label><select name="status"><option value="1"<?= $x['status']?' selected':'' ?>>مفعل</option><option value="0"<?= !$x['status']?' selected':'' ?>>معطل</option></select></div>
                </div>
                <div style="margin-top:8px">
                  <button class="btn btn-gold">حفظ</button>
                  <a class="btn btn-dark" href="?tab=counters&del=<?= (int)$x['id'] ?>&from=about_counters&csrf=<?= $csrf ?>" onclick="return confirm('حذف السجل؟')">حذف</a>
                </div>
              </form>
            </details>
          </td>
        </tr>
        <?php endforeach; if(!$rows): ?>
        <tr><td colspan="6" style="text-align:center;color:#aaa">لا توجد بيانات</td></tr>
        <?php endif; ?>
      </tbody>
    </table>
  </div>
  <?php endif; ?>

  <?php
  /* ========== TIMELINE ========== */
  if ($tab==='timeline'):
    $rows = db()->query("SELECT * FROM about_timeline ORDER BY sort, id")->fetchAll(PDO::FETCH_ASSOC);
  ?>
  <div class="card">
    <h3>إضافة محطة</h3>
    <form method="post">
      <input type="hidden" name="csrf" value="<?= $csrf ?>">
      <input type="hidden" name="scope" value="timeline_create">
      <label>العنوان</label><input name="title" placeholder="2020 — التحوّل الرقمي" required>
      <label>الوصف</label><textarea name="description"></textarea>
      <div class="grid">
        <div><label>الترتيب</label><input type="number" name="sort" value="0"></div>
        <div><label>الحالة</label><select name="status"><option value="1">مفعل</option><option value="0">معطل</option></select></div>
      </div>
      <div style="margin-top:12px"><button class="btn btn-gold">إضافة</button></div>
    </form>
  </div>
  <div class="card">
    <h3>القائمة</h3>
    <table>
      <thead><tr><th>#</th><th>العنوان</th><th>الوصف</th><th>الترتيب</th><th>الحالة</th><th>تحكم</th></tr></thead>
      <tbody>
        <?php foreach($rows as $x): ?>
        <tr>
          <td><?= (int)$x['id'] ?></td>
          <td><?= htmlspecialchars($x['title']) ?></td>
          <td><?= nl2br(htmlspecialchars($x['description'])) ?></td>
          <td><?= (int)$x['sort'] ?></td>
          <td><?= $x['status']?'مفعل':'معطل' ?></td>
          <td>
            <details>
              <summary>تعديل</summary>
              <form method="post" style="margin-top:8px">
                <input type="hidden" name="csrf" value="<?= $csrf ?>">
                <input type="hidden" name="scope" value="timeline_update">
                <input type="hidden" name="id" value="<?= (int)$x['id'] ?>">
                <label>العنوان</label><input name="title" value="<?= htmlspecialchars($x['title']) ?>">
                <label>الوصف</label><textarea name="description"><?= htmlspecialchars($x['description']) ?></textarea>
                <div class="grid">
                  <div><label>الترتيب</label><input type="number" name="sort" value="<?= (int)$x['sort'] ?>"></div>
                  <div><label>الحالة</label><select name="status"><option value="1"<?= $x['status']?' selected':'' ?>>مفعل</option><option value="0"<?= !$x['status']?' selected':'' ?>>معطل</option></select></div>
                </div>
                <div style="margin-top:8px">
                  <button class="btn btn-gold">حفظ</button>
                  <a class="btn btn-dark" href="?tab=timeline&del=<?= (int)$x['id'] ?>&from=about_timeline&csrf=<?= $csrf ?>" onclick="return confirm('حذف السجل؟')">حذف</a>
                </div>
              </form>
            </details>
          </td>
        </tr>
        <?php endforeach; if(!$rows): ?>
        <tr><td colspan="6" style="text-align:center;color:#aaa">لا توجد بيانات</td></tr>
        <?php endif; ?>
      </tbody>
    </table>
  </div>
  <?php endif; ?>

  <?php
  /* ========== TEAM ========== */
  if ($tab==='team'):
    $rows = db()->query("SELECT * FROM about_team ORDER BY sort, id")->fetchAll(PDO::FETCH_ASSOC);
  ?>
  <div class="card">
    <h3>إضافة عضو فريق</h3>
    <form method="post" enctype="multipart/form-data">
      <input type="hidden" name="csrf" value="<?= $csrf ?>">
      <input type="hidden" name="scope" value="team_create">
      <div class="grid">
        <div><label>الاسم</label><input name="name" required></div>
        <div><label>الوظيفة</label><input name="role"></div>
      </div>
      <div class="grid">
        <div><label>الترتيب</label><input type="number" name="sort" value="0"></div>
        <div><label>الحالة</label><select name="status"><option value="1">مفعل</option><option value="0">معطل</option></select></div>
      </div>
      <label>صورة (PNG/JPG/WEBP/SVG)</label>
      <input type="file" name="photo" accept=".png,.jpg,.jpeg,.webp,.svg">
      <div style="margin-top:12px"><button class="btn btn-gold">إضافة</button></div>
    </form>
  </div>
  <div class="card">
    <h3>القائمة</h3>
    <table>
      <thead><tr><th>#</th><th>صورة</th><th>الاسم</th><th>الوظيفة</th><th>الترتيب</th><th>الحالة</th><th>تحكم</th></tr></thead>
      <tbody>
        <?php foreach($rows as $x): ?>
        <tr>
          <td><?= (int)$x['id'] ?></td>
          <td><?php if($x['photo']): ?><img class="avatar" src="../<?= htmlspecialchars($x['photo']) ?>"><?php else: ?>-<?php endif; ?></td>
          <td><?= htmlspecialchars($x['name']) ?></td>
          <td><?= htmlspecialchars($x['role']) ?></td>
          <td><?= (int)$x['sort'] ?></td>
          <td><?= $x['status']?'مفعل':'معطل' ?></td>
          <td>
            <details>
              <summary>تعديل</summary>
              <form method="post" enctype="multipart/form-data" style="margin-top:8px">
                <input type="hidden" name="csrf" value="<?= $csrf ?>">
                <input type="hidden" name="scope" value="team_update">
                <input type="hidden" name="id" value="<?= (int)$x['id'] ?>">
                <div class="grid">
                  <div><label>الاسم</label><input name="name" value="<?= htmlspecialchars($x['name']) ?>"></div>
                  <div><label>الوظيفة</label><input name="role" value="<?= htmlspecialchars($x['role']) ?>"></div>
                </div>
                <div class="grid">
                  <div><label>الترتيب</label><input type="number" name="sort" value="<?= (int)$x['sort'] ?>"></div>
                  <div><label>الحالة</label><select name="status"><option value="1"<?= $x['status']?' selected':'' ?>>مفعل</option><option value="0"<?= !$x['status']?' selected':'' ?>>معطل</option></select></div>
                </div>
                <label>صورة جديدة</label><input type="file" name="photo" accept=".png,.jpg,.jpeg,.webp,.svg">
                <div style="margin-top:8px">
                  <button class="btn btn-gold">حفظ</button>
                  <a class="btn btn-dark" href="?tab=team&del=<?= (int)$x['id'] ?>&from=about_team&csrf=<?= $csrf ?>" onclick="return confirm('حذف السجل؟')">حذف</a>
                </div>
              </form>
            </details>
          </td>
        </tr>
        <?php endforeach; if(!$rows): ?>
        <tr><td colspan="7" style="text-align:center;color:#aaa">لا توجد بيانات</td></tr>
        <?php endif; ?>
      </tbody>
    </table>
  </div>
  <?php endif; ?>

  <?php
  /* ========== FAQ ========== */
  if ($tab==='faq'):
    $rows = db()->query("SELECT * FROM about_faq ORDER BY sort, id")->fetchAll(PDO::FETCH_ASSOC);
  ?>
  <div class="card">
    <h3>إضافة سؤال</h3>
    <form method="post">
      <input type="hidden" name="csrf" value="<?= $csrf ?>">
      <input type="hidden" name="scope" value="faq_create">
      <label>السؤال</label><input name="question" required>
      <label>الإجابة</label><textarea name="answer"></textarea>
      <div class="grid">
        <div><label>الترتيب</label><input type="number" name="sort" value="0"></div>
        <div><label>الحالة</label><select name="status"><option value="1">مفعل</option><option value="0">معطل</option></select></div>
      </div>
      <div style="margin-top:12px"><button class="btn btn-gold">إضافة</button></div>
    </form>
  </div>
  <div class="card">
    <h3>القائمة</h3>
    <table>
      <thead><tr><th>#</th><th>السؤال</th><th>الإجابة</th><th>الترتيب</th><th>الحالة</th><th>تحكم</th></tr></thead>
      <tbody>
        <?php foreach($rows as $x): ?>
        <tr>
          <td><?= (int)$x['id'] ?></td>
          <td><?= htmlspecialchars($x['question']) ?></td>
          <td><?= nl2br(htmlspecialchars($x['answer'])) ?></td>
          <td><?= (int)$x['sort'] ?></td>
          <td><?= $x['status']?'مفعل':'معطل' ?></td>
          <td>
            <details>
              <summary>تعديل</summary>
              <form method="post" style="margin-top:8px">
                <input type="hidden" name="csrf" value="<?= $csrf ?>">
                <input type="hidden" name="scope" value="faq_update">
                <input type="hidden" name="id" value="<?= (int)$x['id'] ?>">
                <label>السؤال</label><input name="question" value="<?= htmlspecialchars($x['question']) ?>">
                <label>الإجابة</label><textarea name="answer"><?= htmlspecialchars($x['answer']) ?></textarea>
                <div class="grid">
                  <div><label>الترتيب</label><input type="number" name="sort" value="<?= (int)$x['sort'] ?>"></div>
                  <div><label>الحالة</label><select name="status"><option value="1"<?= $x['status']?' selected':'' ?>>مفعل</option><option value="0"<?= !$x['status']?' selected':'' ?>>معطل</option></select></div>
                </div>
                <div style="margin-top:8px">
                  <button class="btn btn-gold">حفظ</button>
                  <a class="btn btn-dark" href="?tab=faq&del=<?= (int)$x['id'] ?>&from=about_faq&csrf=<?= $csrf ?>" onclick="return confirm('حذف السجل؟')">حذف</a>
                </div>
              </form>
            </details>
          </td>
        </tr>
        <?php endforeach; if(!$rows): ?>
        <tr><td colspan="6" style="text-align:center;color:#aaa">لا توجد بيانات</td></tr>
        <?php endif; ?>
      </tbody>
    </table>
  </div>
  <?php endif; ?>

  <?php
  /* ========== CTA ========== */
  if ($tab==='cta'):
    $r = db()->query("SELECT * FROM about_cta WHERE id=1")->fetch(PDO::FETCH_ASSOC);
  ?>
  <div class="card">
    <h3>الدعوة للإجراء (CTA)</h3>
    <form method="post">
      <input type="hidden" name="csrf" value="<?= $csrf ?>">
      <input type="hidden" name="scope" value="cta">
      <div class="grid">
        <div><label>العنوان</label><input name="title" value="<?= htmlspecialchars($r['title'] ?? '') ?>" required></div>
        <div><label>نص الزر</label><input name="btn_text" value="<?= htmlspecialchars($r['btn_text'] ?? '') ?>"></div>
      </div>
      <label>الوصف</label><textarea name="subtitle"><?= htmlspecialchars($r['subtitle'] ?? '') ?></textarea>
      <label>رابط الزر</label><input name="btn_link" value="<?= htmlspecialchars($r['btn_link'] ?? '') ?>" placeholder="gold.php أو https://...">
      <div style="margin-top:12px"><button class="btn btn-gold">حفظ</button></div>
    </form>
  </div>
  <?php endif; ?>

</div>
</body>
</html>
<?php include "partials/footer.php"; ?>
